<?php 
    include_once( "inc/config.php" ); 
    include_once( "inc/header.php" ); 
?>
		<!--start page wrapper -->
		<div class="page-wrapper">
			<div class="page-content">

				<!--breadcrumb-->
				<div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
					<div class="breadcrumb-title pe-3">Inventaire</div>
					<div class="ps-3">
						<nav aria-label="breadcrumb">
							<ol class="breadcrumb mb-0 p-0">
								<li class="breadcrumb-item"><a href="javascript:;"><i class="bx bx-home-alt"></i></a>
								</li>
								<li class="breadcrumb-item active" aria-current="page">Ajouter un nouveau produit</li>
							</ol>
						</nav>
					</div>
					<div class="ms-auto">
						<div class="btn-group">
							<button type="button" class="btn btn-primary">Paramètres</button>
							<button type="button" class="btn btn-primary split-bg-primary dropdown-toggle dropdown-toggle-split" data-bs-toggle="dropdown">	<span class="visually-hidden">Toggle Dropdown</span>
							</button>
							<div class="dropdown-menu dropdown-menu-right dropdown-menu-lg-end">	<a class="dropdown-item" href="javascript:;">Action</a>
								<a class="dropdown-item" href="javascript:;">Another action</a>
								<a class="dropdown-item" href="javascript:;">Something else here</a>
								<div class="dropdown-divider"></div>	<a class="dropdown-item" href="javascript:;">Separated link</a>
							</div>
						</div>
					</div>
				</div>
				<!--end breadcrumb-->

              <div class="card">
				  <div class="card-body p-4">
					  <h5 class="card-title">Ajouter un nouveau produit</h5>
					  <hr/>
                       <div class="form-body mt-4">
					    <div class="row">
						   <div class="col-lg-8">
                           <div class="border border-3 p-4 rounded">
							<div class="mb-3">
								<label for="inputProductTitle" class="form-label">Titre du produit</label>
								<input type="email" class="form-control" id="inputProductTitle" placeholder="Entrez le titre du produit">
							  </div>
							  <div class="mb-3">
								<label for="inputProductDescription" class="form-label">Description</label>
								<textarea class="form-control" id="inputProductDescription" rows="3"></textarea>
							  </div>
							  <div class="mb-3">
								<label for="inputProductDescription" class="form-label">Images du produit</label>
								<input id="image-uploadify" type="file" accept=".xlsx,.xls,image/*,.doc,audio/*,.docx,video/*,.ppt,.pptx,.txt,.pdf" multiple>
							  </div>
                            </div>
						   </div>
						   <div class="col-lg-4">
							<div class="border border-3 p-4 rounded">
                              <div class="row g-3">
								<div class="col-md-6">
									<label for="inputPrice" class="form-label">Quantité</label>
									<input type="text" class="form-control" id="inputPrice" placeholder="00.00">
								  </div>
								  <div class="col-md-6">
									<label for="inputCompareatprice" class="form-label">Compare at Price</label>
									<input type="text" class="form-control" id="inputCompareatprice" placeholder="00.00">
								  </div>
								  <div class="col-12">
									<label for="inputProductType" class="form-label">Product Type</label>
									<select class="form-select" id="inputProductType">
										<option></option>
										<option value="1">One</option>
										<option value="2">Two</option>
										<option value="3">Three</option>
									  </select>
								  </div>
								  <div class="col-12">
									<label for="inputCategorie" class="form-label">Catégorie</label>
									<select class="form-select" id="inputCategorie">
										<option></option>
										<option value="1">Pièces</option>
										<option value="2">Périphériques</option>
										<option value="3">Portables</option>
										<option value="4">Ordinateurs</option>
										<option value="5">Réseaux</option>
									  </select>
								  </div>
								  <div class="col-12">
									<label for="inputProduit" class="form-label">Produit</label>
									<select class="form-select" id="inputProduit" disabled="disabled">
										<!-- Pièces -->
										<option value=""></option>
										<option class="1" value="1">Alimentation</option>
										<option class="1" value="BOIT">Boîtier</option>
										<option class="1" value="HDD">Disque Dur</option>
										<option class="1" value="SSD">Disque SSD</option>
										<option class="1" value="MOTHERBOARD">Carte Mère</option>
										<option class="1" value="GPU">Carte Graphique</option>
										<option class="1" value="RAM">Mémoire PC</option>
										<option class="1" value="CPU">Processeur</option>
										<!-- Périphériques -->
										<option class="2" value="2">Écran PC</option>
										<option class="2" value="CLAV/SOUR">Clavier/Souris</option>
										<option class="2" value="IMPR">Imprimante</option>
										<option class="2" value="USB">Clef USB</option>
										<option class="2" value="HDD EXT">Disque Dur Externe</option>
										<option class="2" value="ONDU">Onduleur</option>
										<!-- Portables -->
									  </select>
								  </div>
								  <div class="col-12">
									<label for="inputProductTags" class="form-label">Product Tags</label>
									<input type="text" class="form-control" id="inputProductTags" placeholder="Enter Product Tags">
								  </div>
								  <div class="col-12">
									  <div class="d-grid">
                                         <button type="button" class="btn btn-primary">Save Product</button>
									  </div>
								  </div>
							  </div> 
						  </div>
						  </div>
					   </div><!--end row-->
					</div>
				  </div>
			  </div>

			</div>
		</div>
		<!--end page wrapper -->
		<script>
		$(document).ready(function () {
			$('#image-uploadify').imageuploadify();
		})
		</script>
		
<?php 
    include_once( "inc/footer.php" ); 
?>